VERSION 5.00
Object = "{4DE9E2A3-150F-11CF-8FBF-444553540000}#4.0#0"; "DlxOCX32.ocx"
Begin VB.Form Form1 
   Caption         =   "Timer Tic Messages at Programmed Interval"
   ClientHeight    =   3525
   ClientLeft      =   1995
   ClientTop       =   1785
   ClientWidth     =   6045
   LinkTopic       =   "Form1"
   ScaleHeight     =   3525
   ScaleWidth      =   6045
   Begin VB.TextBox txtInterval 
      Height          =   285
      Left            =   3480
      TabIndex        =   3
      Text            =   "0.5"
      Top             =   720
      Width           =   615
   End
   Begin VB.CommandButton cmdStop 
      Caption         =   "Stop"
      Height          =   375
      Left            =   1320
      TabIndex        =   2
      Top             =   1320
      Width           =   1695
   End
   Begin VB.CommandButton cmdStart 
      Caption         =   "Start"
      Height          =   375
      Left            =   1320
      TabIndex        =   1
      Top             =   720
      Width           =   1695
   End
   Begin DlsrLib.DriverLINXSR SR 
      Left            =   960
      Top             =   2640
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      BackColor       =   &H000000FF&
      Caption         =   "  KEITHLEY  "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FFFFFF&
      Height          =   360
      Left            =   480
      TabIndex        =   5
      Top             =   120
      Width           =   1845
   End
   Begin VB.Label Label1 
      Caption         =   "seconds"
      Height          =   255
      Left            =   4320
      TabIndex        =   4
      Top             =   720
      Width           =   735
   End
   Begin VB.Label lblStatus 
      BackColor       =   &H8000000E&
      Caption         =   "Status"
      Height          =   255
      Left            =   1320
      TabIndex        =   0
      Top             =   1920
      Width           =   3375
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Dim interval As Single
' this VB6 example was written in Win2K SP1 with a
' KPCI-3108 using 3108-850A04 version of DriverLINX
' it programs logical channel 0 of the CT subsystem to send
' a Timer_Tic message at requested intervals.
'
' logical channel 0 of CT subsystem is the default channel used
' for pacing the A/D subsystem, so be sure you have no resource contention
'
' no connections to the CT are required....

Private Sub cmdStart_Click()
On Error GoTo enterValue
interval = CSng(txtInterval.Text)
With SR
.Req_op = DL_START
.Req_subsystem = DL_CT
.Req_mode = DL_INTERRUPT
.Evt_Str_type = DL_COMMAND
.Evt_Stp_type = DL_COMMAND
.Evt_Tim_type = DL_RATEEVENT
.Evt_Tim_rateChannel = 0  ' CT channel 0 is a 32bit cascade of hardware CT1 and CT2 in the 82C54 chip
.Evt_Tim_rateClock = DL_INTERNAL1  ' value of internal1 is set by the DLinx Config Panel
' default value of Internal1 is 5MHz
' 5MHz / 2^32 = from 0.001 to faster than practical for Windows' messaging
' if using a single 16bit counter, e.g. counter channel 1, then
' 5MHz / 2 ^16 = 76 Hz is slowest rate allowed to ask for (13.1 msec)
.Evt_Tim_rateGate = DL_NOCONNECT
.Evt_Tim_rateMode = DL_RATEGEN
.Evt_Tim_ratePeriod = .DLSecs2Tics(.Evt_Tim_rateChannel, interval) ' how often to send message
' no buffers, no channels => send TimerTic messages
.Sel_buf_N = 0
.Sel_chan_N = 0
.Refresh
End With
lblStatus.Caption = SR.Message
Exit Sub
enterValue:
MsgBox "Please enter a numeric value", vbCritical
txtInterval.Text = "0.5"
End Sub

Private Sub cmdStop_Click()
With SR
.Req_op = DL_STOP
.Refresh
End With
End Sub

Private Sub Form_Load()
With SR
.Req_DLL_name = "kpci3108$"  ' $ on end means load only the kpci3108 driver
.Req_device = 0   ' device number assigned in DLinx Config Panel
.Req_mode = DL_OTHER
.Req_op = DL_INITIALIZE
.Req_subsystem = DL_DEVICE
.Refresh
End With
lblStatus.Caption = SR.Message
End Sub


Private Sub Form_Terminate()
' stop the task just in case it is not already...
cmdStop_Click
' unload the driver on exit
SR.Req_DLL_name = ""
End Sub

Private Sub SR_TimerTic(task As Integer, device As Integer, subsystem As Integer, mode As Integer)
Static counter As Long
counter = counter + 1
lblStatus.Caption = "Timer Tic occurred : " & Str(counter) & " times"
End Sub
